<?php
// Include database connection
include('db.php'); // Assuming you have a db.php file for DB connection

// Get the JSON data from the request body
$data = json_decode(file_get_contents('php://input'), true);

// Check if the required fields are provided
if (isset($data['ID']) && isset($data['Category_ID']) && isset($data['Subcategory_Name'])) {
    
    // Get the values from the request
    $ID = $data['ID'];
    $Category_ID = $data['Category_ID'];
    $Subcategory_Name = $data['Subcategory_Name'];
    $image = isset($data['image']) ? $data['image'] : null; // Optional
    $Delete_status = isset($data['Delete_status']) ? $data['Delete_status'] : 0; // Default to 0 if not provided

    // Prepare SQL query to update the subcategory
    $query = "UPDATE subcategory SET 
              Category_ID = ?, 
              Subcategory_Name = ?, 
              image = ?, 
              Delete_status = ?
              WHERE ID = ?";

    // Prepare the statement
    if ($stmt = $conn->prepare($query)) {
        // Bind parameters
        $stmt->bind_param("issii", $Category_ID, $Subcategory_Name, $image, $Delete_status, $ID);

        // Execute the query
        if ($stmt->execute()) {
            // Check if the row was updated
            if ($stmt->affected_rows > 0) {
                // Respond with a success message
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Subcategory updated successfully.'
                ]);
            } else {
                // If no rows were affected, return an error message
                echo json_encode([
                    'status' => 'error',
                    'message' => 'No changes made. The ID may not exist.'
                ]);
            }
        } else {
            // Query execution failed
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update subcategory.'
            ]);
        }

        // Close the prepared statement
        $stmt->close();
    } else {
        // If the query preparation fails
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to prepare the query.'
        ]);
    }

} else {
    // Missing required fields
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required fields: ID, Category_ID, Subcategory_Name.'
    ]);
}

// Close the database connection
$conn->close();
?>
